/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.blocks;

import crystalspider.justverticalslabs.blocks.VerticalSlabBlock;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TranslucentVerticalSlabBlock
extends VerticalSlabBlock {
    public TranslucentVerticalSlabBlock() {
        super(Material.f_76275_);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    @Override
    public boolean m_7923_(BlockState state) {
        return (Boolean)state.m_61143_((Property)OCCLUSION) != false && super.m_7923_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(getter, pos);
        if (referredBlockState != null) {
            return VerticalSlabBlock.Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredBlockState).m_60631_(arg_0, arg_1), () -> true, getter, pos);
        }
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter getter, BlockPos pos) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
            if (referredBlockState != null) {
                return VerticalSlabBlock.Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredBlockState).m_60792_(arg_0, arg_1), () -> Float.valueOf(1.0f), getter, pos).floatValue();
            }
            return VerticalSlabBlock.Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredSlabState).m_60792_(arg_0, arg_1), () -> Float.valueOf(1.0f), getter, pos).floatValue();
        }
        return 1.0f;
    }

    public int m_7753_(BlockState state, BlockGetter getter, BlockPos pos) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
        if (referredBlockState != null) {
            return VerticalSlabBlock.Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredBlockState).m_60739_(arg_0, arg_1), () -> super.m_7753_(state, getter, pos), getter, pos);
        }
        if (referredSlabState != null) {
            return VerticalSlabBlock.Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredSlabState).m_60739_(arg_0, arg_1), () -> super.m_7753_(state, getter, pos), getter, pos);
        }
        return super.m_7753_(state, getter, pos);
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter getter, BlockPos pos, BlockState state, BlockState neighborState, Direction direction) {
        BlockState referredSlabState = VerticalSlabUtils.getSafeReferredSlabState(getter, pos);
        BlockState neighborReferredSlabState = VerticalSlabUtils.getSafeReferredSlabState(getter, pos.m_121945_(direction));
        if (referredSlabState != null && neighborReferredSlabState != null) {
            return referredSlabState == neighborReferredSlabState && new Grid((Direction)state.m_61143_((Property)FACING), (StairsShape)state.m_61143_((Property)SHAPE), (Boolean)state.m_61143_((Property)DOUBLE)).isConnected(new Grid((Direction)neighborState.m_61143_((Property)FACING), (StairsShape)neighborState.m_61143_((Property)SHAPE), (Boolean)neighborState.m_61143_((Property)DOUBLE)), direction);
        }
        return false;
    }

    private class Grid {
        private final short count = (short)4;
        private final boolean[] quadrants = new boolean[4];

        Grid(Direction facing, StairsShape stairsShape, boolean isDouble) {
            if (isDouble) {
                Arrays.fill(this.quadrants, true);
            } else {
                switch (stairsShape) {
                    case STRAIGHT: {
                        this.quadrants[2] = true;
                        this.quadrants[3] = true;
                        break;
                    }
                    case INNER_LEFT: {
                        this.quadrants[1] = true;
                        this.quadrants[2] = true;
                        this.quadrants[3] = true;
                        break;
                    }
                    case INNER_RIGHT: {
                        this.quadrants[0] = true;
                        this.quadrants[2] = true;
                        this.quadrants[3] = true;
                        break;
                    }
                    case OUTER_LEFT: {
                        this.quadrants[2] = true;
                        break;
                    }
                    case OUTER_RIGHT: {
                        this.quadrants[3] = true;
                    }
                }
                this.rotateQuadrants(facing);
            }
        }

        boolean isConnected(Grid neighbor, Direction direction) {
            if (direction.m_122434_() == Direction.Axis.Y) {
                return Arrays.equals(this.quadrants, neighbor.quadrants);
            }
            switch (direction) {
                case NORTH: {
                    return this.quadrants[0] == neighbor.quadrants[3] && this.quadrants[1] == neighbor.quadrants[2] && (this.quadrants[0] || this.quadrants[1]);
                }
                case SOUTH: {
                    return this.quadrants[3] == neighbor.quadrants[0] && this.quadrants[2] == neighbor.quadrants[1] && (this.quadrants[3] || this.quadrants[2]);
                }
                case WEST: {
                    return this.quadrants[0] == neighbor.quadrants[1] && this.quadrants[3] == neighbor.quadrants[2] && (this.quadrants[0] || this.quadrants[3]);
                }
                case EAST: {
                    return this.quadrants[1] == neighbor.quadrants[0] && this.quadrants[2] == neighbor.quadrants[3] && (this.quadrants[1] || this.quadrants[2]);
                }
            }
            return false;
        }

        private void rotateQuadrants(Direction facing) {
            for (int s = 1; s <= facing.m_122416_(); s = (int)((short)(s + 1))) {
                boolean tmp = this.quadrants[3];
                for (int c = 3; c > 0; c = (int)((short)(c - 1))) {
                    this.quadrants[c] = this.quadrants[c - 1];
                }
                this.quadrants[0] = tmp;
            }
        }
    }
}

